# MDOT Trip Planner

MDOT GTFS Trip Planner application based on a Vite + React frontend & tRPC backend. Enables users to track public transportation routes and potential trips in the area.

## Architecture

- `apps/web` - Simple vite web application for interacting and displaying route information.
- `apps/admin` - System administration portal for uploading otp feeds, promoting feeds between environments, managing agencies, etc.
- `apps/otp` - OTP scripts and functions.
- `packages/shared-backend` - Amplify backend cdk configuration

## Getting Started

### Prerequisites

- Install node
- Install pnpm (`npm i -g pnpm`)

### Setup

**dev environment**

```bash
pnpm i

# prepares environment variables for projects (.env must be updated with live tokens/keys)
pnpm setup
```

**backend**

Add or generate `amplify_outputs.json` to `./apps/web/` to bind to backend services.
Download a running backend from the Amplify deployed backend resource or generate one using:

```bash
cd apps/web
npx ampx sandbox
```

#### Configure .env

- `apps/web`

  - **VITE_CLIENT_ID** - Esri Geocode Client ID
  - **VITE_CLIENT_SECRET** - Esri Geocode Client Secret
  - **VITE_API_URL** - tRPC api url
  - **VITE_AWS_PLACES_INDEX_KEY** - AWS Places Index Key (api key for the service)
  - **VITE_AWS_PLACES_INDEX_NAME** - AWS Places Index Name (name of the service)
  - **VITE_AWS_RUM_IDENTITY_POOL_ID** - AWS RUM Identity ID
  - **VITE_AWS_RUM_APP_ID** - AWS RUM App ID
  - **VITE_AWS_RUM_ENDPOINT** - AWS RUM Endpoint
  - **VITE_AWS_RUM_REGION** - AWS RUM Region

  - CONFIG_GOOGLE_ANALYTICS_ID - Google analytics id (added during vite build)

- `apps/admin`

- `packages/shared-backend`

  - BACKEND_AWS_COGNITO_RESOURCE_NAME_PREFIX - Backend Resource Prefix (default `local`)
  - BACKEND_AWS_COGNITO_GROUP_NAME - Backend Admin Group name (default `EVERYONE`)
    - Allows access to admin page
    - Allows executing OTP builds + lambda functions
  - BACKEND_AWS_S3_BUCKET_NAME - Bucket name of OTP files
  - BACKEND_AWS_S3_BUCKET_REGION - Bucket region
  - BACKEND_AWS_S3_POLICY_ARN - Bucket ARN policy
  - BACKEND_AWS_STEP_FUNCTION_ARN - Build OTP Step function ARN

#### Run development server

```bash
pnpm dev # Runs development server for server & web
pnpm admin:dev # Runs development server for MDOT GTFS admin portal
```

## Technologies (Front End)

**Stack**

- [Turborepo](https://turbo.build/repo) - Build System + Monorepo Setup
- [Vite](https://vitejs.dev/) - Frontend Tooling | Bundling | Dev Server | etc.
- [React](https://react.dev/) - Front End Library (Framework)
- [Typescript](https://www.typescriptlang.org/) - Scripting Language

**Styling**

- [Tailwindcss](https://tailwindcss.com/) - CSS classes
- [Radix](https://www.radix-ui.com/) - Headless react components

**Mapping**

- [Leaflet](https://leafletjs.com/) - Map presentation
- [AWS Places Index](https://docs.aws.amazon.com/location/latest/developerguide/places-concepts.html) - Locations Index

## Deployments

Deployments are triggered on code push and synchronized using webhooks executed by backend code builds.

### Workflow

**Automatic builds are disabled for mdot-gtfs-admin-portal and mdot-gtfs-trip-planner.**

This ensures the frontend amplify_outputs.json file is generated with the most up to date configuration

Once the backend build is complete, it triggers webhooks to build the corresponding frontend.

### Adding new builds

**_[Read more on the amplify website](https://docs.amplify.aws/nextjs/deploy-and-host/fullstack-branching/mono-and-multi-repos/)_**

To trigger builds on feature or pr branches, first add a new webhook for the desired branch in Amplify.

- Ensure Auto-build flag is disabled under the App settings/Branch settings configuration
- Navigate to Hosting/Build settings on the app
- Press `Create webhook`
- Ensure the branch is set to the expected one.

Add a new .env variable to the backend through the Amplify Console

Update the ./amplify.yml file execute the new webhook

```yaml
- appRoot: packages/shared-backend
  backend:
    # ...
  frontend:
    phases:
      build:
        commands:
          # ...
          - |
            if [ -n "${YOUR_BUILD_URL_VARIABLE}" ]; then
              curl -X POST -d {} "$YOUR_BUILD_URL_VARIABLE" -H "Content-Type:application/json"
            fi
```
